VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMedia"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private mMediaPlayer As MEDIAPLAYERS
Public CurrentTrack As String
Public Enum MEDIAPLAYERS
    None& = 0
    iTunes& = 1
    Foobar& = 2
    Winamp& = 3
    WindowsMediaPlayer& = 4
End Enum

Public Property Let MediaPlayer(Value As MEDIAPLAYERS)
    mMediaPlayer = Value
    If Value = iTunes Then
        If Opened Then
            Unload frmiTunes
            Load frmiTunes
        End If
    Else
        Unload frmiTunes
    End If
End Property

Public Property Get MediaPlayer() As MEDIAPLAYERS
    MediaPlayer = mMediaPlayer
End Property

Public Property Get MediaPlayerToString() As String
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        MediaPlayerToString = "foobar2000"
    Case MEDIAPLAYERS.iTunes
        MediaPlayerToString = "iTunes"
    Case MEDIAPLAYERS.Winamp
        MediaPlayerToString = "Winamp"
    Case MEDIAPLAYERS.WindowsMediaPlayer
        MediaPlayerToString = "Windows Media Player"
    Case Else
        MediaPlayerToString = "None"
    End Select
End Property

Private Function FoobarHandle() As Long
    FoobarHandle = FindWindow("{E7076D1C-A7BF-4f39-B771-BCBE88F2A2A8}", vbNullString) Or FindWindow("{DA7CD0DE-1602-45e6-89A1-C2CA151E008E}/1", vbNullString)
End Function

Private Function WinampHandle() As Long
    WinampHandle = FindWindow("Winamp v1.x", vbNullString)
End Function

Private Function iTunesHandle() As Long
    iTunesHandle = FindWindow("iTunes", vbNullString)
End Function

Private Function WmpHandle() As Long
    WmpHandle = FindWindow("WMPlayerApp", vbNullString)
End Function

Public Function Opened() As Boolean
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Opened = (FoobarHandle <> 0)
    Case MEDIAPLAYERS.iTunes
        Opened = (iTunesHandle <> 0)
    Case MEDIAPLAYERS.Winamp
        Opened = (WinampHandle <> 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Opened = (WmpHandle <> 0)
    End Select
End Function

Public Sub BeginPlay()
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_PLAY, 0)
    Case MEDIAPLAYERS.iTunes
    
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PLAY, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PLAY, 0)
    End Select
End Sub

Public Sub StopPlay()
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_STOP, 0)
    Case MEDIAPLAYERS.iTunes
    
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_STOP, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_STOP, 0)
    End Select
End Sub

Public Sub PausePlay()
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_PAUS, 0)
    Case MEDIAPLAYERS.iTunes
    
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PAUS, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PAUS, 0)
    End Select
End Sub

Public Sub NextTrack()
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_NEXT, 0)
    Case MEDIAPLAYERS.iTunes
    
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_NEXT, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_NEXT, 0)
    End Select
End Sub

Public Sub PreviousTrack()
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_KEYDOWN, FOOBAR_PREV, 0)
    Case MEDIAPLAYERS.iTunes
    
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PREV, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PREV, 0)
    End Select
End Sub

Private Function GetTitle(Handle As Long) As String
    Dim bufLen As Long, buf As String
    bufLen = SendMessage(Handle, &HE, &H0, ByVal &H0)
    buf = String$(bufLen, 0)
    SendMessage Handle, &HD, bufLen + 1, ByVal buf
    buf = Replace$(buf, "_", Space$(1))
    buf = Replace$(buf, "&", "&&")
    buf = Replace$(buf, Space$(2), Space$(1))
    If InStrB(buf, "[foobar") > 0 Then buf = Left$(buf, InStr(buf, "[foobar") - 1)
    If InStrB(buf, " - Windows Media Player") > 0 Then buf = Left$(buf, InStr(buf, " - Windows Media Player") - 1)
    If InStrB(buf, " - Winamp") > 0 Then buf = Left$(buf, InStr(buf, " - Winamp") - 1)
    GetTitle = buf
End Function

Public Function Track() As String
    If Not Opened Then
        Track = MediaPlayerToString & " is not running!"
        Exit Function
    End If
    
    On Error GoTo hErr:
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Track = GetTitle(FoobarHandle)
    Case MEDIAPLAYERS.iTunes
        Track = frmiTunes.CurrentTrack
    Case MEDIAPLAYERS.Winamp
        Track = GetTitle(WinampHandle)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Track = GetTitle(WmpHandle)
    End Select
    
hErr:
    If Track = "Windows Media Player" Then Track = "Blogging plugin not running or playback has not started!"
    If Track Like "foobar2000*" Then Track = "Playback has not started!"
    If Len(Track) = 0 Then Track = MediaPlayerToString & " is not playing!"
    
    Track = Trim$(Track)
End Function
